/*
 * Globalize Culture fi
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "fi", "default", {
	name: "fi",
	englishName: "Finnish",
	nativeName: "suomi",
	language: "fi",
	numberFormat: {
		",": " ",
		".": ",",
		negativeInfinity: "-INF",
		positiveInfinity: "INF",
		percent: {
			",": " ",
			".": ","
		},
		currency: {
			pattern: ["-n $","n $"],
			",": " ",
			".": ",",
			symbol: "€"
		}
	},
	calendars: {
		standard: {
			"/": ".",
			firstDay: 1,
			days: {
				names: ["sunnuntai","maanantai","tiistai","keskiviikko","torstai","perjantai","lauantai"],
				namesAbbr: ["su","ma","ti","ke","to","pe","la"],
				namesShort: ["su","ma","ti","ke","to","pe","la"]
			},
			months: {
				names: ["tammikuu","helmikuu","maaliskuu","huhtikuu","toukokuu","kesäkuu","heinäkuu","elokuu","syyskuu","lokakuu","marraskuu","joulukuu",""],
				namesAbbr: ["tammi","helmi","maalis","huhti","touko","kesä","heinä","elo","syys","loka","marras","joulu",""]
			},
			AM: null,
			PM: null,
			patterns: {
				d: "d.M.yyyy",
				D: "d. MMMM'ta 'yyyy",
				t: "H:mm",
				T: "H:mm:ss",
				f: "d. MMMM'ta 'yyyy H:mm",
				F: "d. MMMM'ta 'yyyy H:mm:ss",
				M: "d. MMMM'ta'",
				Y: "MMMM yyyy"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "Käyttäjä",
  "filetype_box user": "Käyttäjä",
  "html": "HTML-tiedosto",
  "filetype_html": "HTML-tiedosto",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Verkkosivu",
  "filetype_webscraperwebpage": "Verkkosivu",
  "image": "Kuva",
  "filetype_image": "Kuva",
  "folder": "Kansio",
  "filetype_folder": "Kansio",
  "txt": "Teksti",
  "filetype_txt": "Teksti",
  "zip": "Zip-tiedosto",
  "filetype_zip": "Zip-tiedosto",
  "olefile": "OLE-tiedosto",
  "filetype_olefile": "OLE-tiedosto",
  "gmailmessage": "Gmail-viesti",
  "filetype_gmailmessage": "Gmail-viesti",
  "pdf": "PDF-tiedosto",
  "filetype_pdf": "PDF-tiedosto",
  "swf": "Flash-tiedosto",
  "filetype_swf": "Flash-tiedosto",
  "xml": "XML-tiedosto",
  "filetype_xml": "XML-tiedosto",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS-syöte",
  "filetype_rssitem": "RSS-syöte",
  "doc": "Asiakirja",
  "filetype_doc": "Asiakirja",
  "docx": "Microsoft Word -asiakirja",
  "filetype_docx": "Microsoft Word -asiakirja",
  "xls": "Laskentataulukkotiedosto",
  "filetype_xls": "Laskentataulukkotiedosto",
  "ppt": "Esitystiedosto",
  "filetype_ppt": "Esitystiedosto",
  "video": "Video",
  "filetype_video": "Video",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Text -tiedosto",
  "filetype_odt": "Open Text -tiedosto",
  "lithiummessage": "Lithium-viesti",
  "filetype_lithiummessage": "Lithium-viesti",
  "lithiumthread": "Lithium-viestiketju",
  "filetype_lithiumthread": "Lithium-viestiketju",
  "lithiumboard": "Lithium-elektroninen taulu",
  "filetype_lithiumboard": "Lithium-elektroninen taulu",
  "lithiumcategory": "Lithium-kategoria",
  "filetype_lithiumcategory": "Lithium-kategoria",
  "lithiumcommunity": "Lithium-yhteisö",
  "filetype_lithiumcommunity": "Lithium-yhteisö",
  "people": "Käyttäjä",
  "objecttype_people": "Käyttäjä",
  "message": "Viesti",
  "objecttype_message": "Viesti",
  "feed": "RSS-syöte",
  "objecttype_feed": "RSS-syöte",
  "thread": "Viestiketju",
  "objecttype_thread": "Viestiketju",
  "file": "Tiedosto",
  "objecttype_file": "Tiedosto",
  "board": "Taulukko",
  "objecttype_board": "Taulukko",
  "category": "Kategoria",
  "objecttype_category": "Kategoria",
  "account": "Tili",
  "objecttype_account": "Tili",
  "annotation": "Huomautus",
  "objecttype_annotation": "Huomautus",
  "campaign": "Kampanja",
  "objecttype_campaign": "Kampanja",
  "case": "Tapaus",
  "objecttype_case": "Tapaus",
  "contact": "Yhteydenotto",
  "objecttype_contact": "Yhteydenotto",
  "contract": "Sopimus",
  "objecttype_contract": "Sopimus",
  "event": "Tapahtuma",
  "objecttype_event": "Tapahtuma",
  "email": "Sähköposti",
  "objecttype_email": "Sähköposti",
  "goal": "Tavoite",
  "objecttype_goal": "Tavoite",
  "objecttype_incident": "Tapaus",
  "invoice": "Lasku",
  "objecttype_invoice": "Lasku",
  "lead": "Johto",
  "objecttype_lead": "Johto",
  "list": "Lista",
  "objecttype_list": "Markkinointilista",
  "solution": "Ratkaisu",
  "objecttype_solution": "Ratkaisu",
  "task": "Tehtävä",
  "objecttype_task": "Tehtävä",
  "user": "Käyttäjä",
  "objecttype_user": "Käyttäjä",
  "attachment": "Liite",
  "objecttype_attachment": "Liite",
  "casecomment": "Tapauskommentti",
  "objecttype_casecomment": "Tapauskommentti",
  "opportunity": "Mahdollisuus",
  "objecttype_opportunity": "Mahdollisuus",
  "opportunityproduct": "Tuotemahdollisuus",
  "objecttype_opportunityproduct": "Tuotemahdollisuus",
  "feeditem": "Jutustelu",
  "objecttype_feeditem": "Jutustelu",
  "feedcomment": "Jutustelu",
  "objecttype_feedcomment": "Jutustelu",
  "note": "Huomautus",
  "objecttype_note": "Huomautus",
  "product": "Tuote",
  "objecttype_product": "Tuote",
  "partner": "Kumppani",
  "objecttype_partner": "Kumppani",
  "queueitem": "Jonotuskohde",
  "objecttype_queueitem": "Jonotuskohde",
  "quote": "Tarjous",
  "objecttype_quote": "Tarjous",
  "salesliterature": "Mainosesite",
  "objecttype_salesliterature": "Mainosesite",
  "salesorder": "Tilaus",
  "objecttype_salesorder": "Tilaus",
  "service": "Palvelu",
  "objecttype_service": "Palvelu",
  "socialprofile": "Sosiaalinen profiili",
  "objecttype_socialprofile": "Sosiaalinen profiili",
  "kbdocumentation": "Dokumentaatio",
  "objecttype_kbdocumentation": "Dokumentaatio",
  "kbtechnicalarticle": "Dokumentaatio",
  "objecttype_kbtechnicalarticle": "Dokumentaatio",
  "kbsolution": "Ratkaisu",
  "objecttype_kbsolution": "Ratkaisu",
  "kbknowledgearticle": "Tietoartikkeli",
  "objecttype_kbknowledgearticle": "Tietoartikkeli",
  "kbattachment": "Liite",
  "objecttype_kbattachment": "Liite",
  "kbarticle": "Artikkeli",
  "objecttype_kbarticle": "Artikkeli",
  "kbarticlecomment": "Artikkelin kommentti",
  "objecttype_kbarticlecomment": "Artikkelin kommentti",
  "knowledgearticle": "Tietoartikkeli",
  "objecttype_knowledgearticle": "Tietoartikkeli",
  "topic": "Aihe",
  "objecttype_topic": "Aihe",
  "dashboard": "Koontinäyttö",
  "objecttype_dashboard": "Koontinäyttö",
  "contentversion": "Asiakirja",
  "objecttype_contentversion": "Asiakirja",
  "collaborationgroup": "Yhteistyöryhmä",
  "objecttype_collaborationgroup": "Yhteistyöryhmä",
  "spportal": "Portaali",
  "filetype_spportal": "Portaali",
  "spsite": "Sivusto",
  "filetype_spsite": "Sivusto",
  "spuserprofile": "SharePoint-käyttäjä",
  "filetype_spuserprofile": "SharePoint-käyttäjä",
  "sparea": "Alue",
  "filetype_sparea": "Alue",
  "spannouncement": "Ilmoitus",
  "filetype_spannouncement": "Ilmoitus",
  "spannouncementlist": "Ilmoitukset",
  "filetype_spannouncementlist": "Ilmoitukset",
  "spcontact": "Yhteydenotto",
  "filetype_spcontact": "Yhteydenotto",
  "spcontactlist": "Yhteyshenkilöt",
  "filetype_spcontactlist": "Yhteyshenkilöt",
  "spcustomlist": "Räätälöity lista",
  "filetype_spcustomlist": "Räätälöity lista",
  "spdiscussionboard": "Keskustelufoorumi",
  "filetype_spdiscussionboard": "Keskustelufoorumi",
  "spdiscussionboardlist": "Keskustelufoorumit",
  "filetype_spdiscussionboardlist": "Keskustelufoorumit",
  "spdocumentlibrarylist": "Asiakirjakirjasto",
  "filetype_spdocumentlibrarylist": "Asiakirjakirjasto",
  "spevent": "Tapahtuma",
  "filetype_spevent": "Tapahtuma",
  "speventlist": "Tapahtumat",
  "filetype_speventlist": "Tapahtumat",
  "spformlibrarylist": "Lomakekirjasto",
  "filetype_spformlibrarylist": "Lomakekirjasto",
  "spissue": "Ongelma",
  "filetype_spissue": "Ongelma",
  "spissuelist": "Ongelmat",
  "filetype_spissuelist": "Ongelmat",
  "splink": "Linkki",
  "filetype_splink": "Linkki",
  "splinklist": "Linkit",
  "filetype_splinklist": "Linkit",
  "sppicturelibrarylist": "Kuvakirjasto",
  "filetype_sppicturelibrarylist": "Kuvakirjasto",
  "spsurvey": "Kysely",
  "filetype_spsurvey": "Kysely",
  "spsurveylist": "Kyselyt",
  "filetype_spsurveylist": "Kyselyt",
  "sptask": "Tehtävä",
  "filetype_sptask": "Tehtävä",
  "sptasklist": "Tehtävät",
  "filetype_sptasklist": "Tehtävät",
  "spagenda": "Päiväohjelma",
  "filetype_spagenda": "Päiväohjelma",
  "spagendalist": "Päiväohjelmat",
  "filetype_spagendalist": "Päiväohjelmat",
  "spattendee": "Osallistuja",
  "filetype_spattendee": "Osallistuja",
  "spattendeelist": "Osallistujat",
  "filetype_spattendeelist": "Osallistujat",
  "spcustomgridlist": "Räätälöity taulukko",
  "filetype_spcustomgridlist": "Räätälöity taulukko",
  "spdecision": "Päätös",
  "filetype_spdecision": "Päätös",
  "spdecisionlist": "Päätökset",
  "filetype_spdecisionlist": "Päätökset",
  "spobjective": "Tavoite",
  "filetype_spobjective": "Tavoite",
  "spobjectivelist": "Tavoitteet",
  "filetype_spobjectivelist": "Tavoitteet",
  "sptextbox": "Tekstiruutu",
  "filetype_sptextbox": "Tekstiruutu",
  "sptextboxlist": "Tekstiruutulista",
  "filetype_sptextboxlist": "Tekstiruutulista",
  "spthingstobring": "Tuotava asia",
  "filetype_spthingstobring": "Tuotava asia",
  "spthingstobringlist": "Tuotavat asiat",
  "filetype_spthingstobringlist": "Tuotavat asiat",
  "sparealisting": "Aluelistaus",
  "filetype_sparealisting": "Aluelistaus",
  "spmeetingserie": "Tapaamissarja",
  "filetype_spmeetingserie": "Tapaamissarja",
  "spmeetingserielist": "Tapaamissarjan lista",
  "filetype_spmeetingserielist": "Tapaamissarjan lista",
  "spsitedirectory": "Sivuston hakemiston kohde",
  "filetype_spsitedirectory": "Sivuston hakemiston kohde",
  "spsitedirectorylist": "Sivuston hakemisto",
  "filetype_spsitedirectorylist": "Sivuston hakemisto",
  "spdatasource": "Tietolähde",
  "filetype_spdatasource": "Tietolähde",
  "spdatasourcelist": "Tietolähdelista",
  "filetype_spdatasourcelist": "Tietolähdelista",
  "splisttemplatecataloglist": "Mallilistan galleria",
  "filetype_splisttemplatecataloglist": "Mallilistan galleria",
  "spwebpartcataloglist": "WebPart-galleria",
  "filetype_spwebpartcataloglist": "WebPart-galleria",
  "spwebtemplatecataloglist": "Sivustomallin galleria",
  "filetype_spwebtemplatecataloglist": "Sivustomallin galleria",
  "spworkspacepagelist": "Työtilan sivut",
  "filetype_spworkspacepagelist": "Työtilan sivut",
  "spunknownlist": "Räätälöity lista",
  "filetype_spunknownlist": "Räätälöity lista",
  "spadministratortask": "Järjestelmänvalvojan tehtävä",
  "filetype_spadministratortask": "Järjestelmänvalvojan tehtävä",
  "spadministratortasklist": "Järjestelmänvalvojan tehtävät",
  "filetype_spadministratortasklist": "Järjestelmänvalvojan tehtävät",
  "spareadocumentlibrarylist": "Alueen asiakirjakirjasto",
  "filetype_spareadocumentlibrarylist": "Alueen asiakirjakirjasto",
  "spblogcategory": "Blogikategoria",
  "filetype_spblogcategory": "Blogikategoria",
  "spblogcategorylist": "Blogikategoriat",
  "filetype_spblogcategorylist": "Blogikategoriat",
  "spblogcomment": "Blogikommentti",
  "filetype_spblogcomment": "Blogikommentti",
  "spblogcommentlist": "Blogikommentit",
  "filetype_spblogcommentlist": "Blogikommentit",
  "spblogpost": "Blogijulkaisu",
  "filetype_spblogpost": "Blogijulkaisu",
  "spblogpostlist": "Blogijulkaisut",
  "filetype_spblogpostlist": "Blogijulkaisut",
  "spdataconnectionlibrarylist": "Tietoyhteyksien kirjasto",
  "filetype_spdataconnectionlibrarylist": "Tietoyhteyksien kirjasto",
  "spdistributiongroup": "Jakeluryhmä",
  "filetype_spdistributiongroup": "Jakeluryhmä",
  "spdistributiongrouplist": "Jakeluryhmät",
  "filetype_spdistributiongrouplist": "Jakeluryhmät",
  "spipfslist": "InfoPath-lomakkeiden palvelimet",
  "filetype_spipfslist": "InfoPath-lomakkeiden palvelimet",
  "spkeyperformanceindicator": "Avainsuorituksen ilmaisin",
  "filetype_spkeyperformanceindicator": "Avainsuorituksen ilmaisin",
  "spkeyperformanceindicatorlist": "Avainsuoritusten ilmaisimet",
  "filetype_spkeyperformanceindicatorlist": "Avainsuoritusten ilmaisimet",
  "splanguagesandtranslator": "Kielet ja kääntäjä",
  "filetype_splanguagesandtranslator": "Kielet ja kääntäjä",
  "splanguagesandtranslatorlist": "Kielet ja kääntäjät",
  "filetype_splanguagesandtranslatorlist": "Kielet ja kääntäjät",
  "spmasterpagescataloglist": "Pääsivun galleria",
  "filetype_spmasterpagescataloglist": "Pääsivun galleria",
  "spnocodeworkflowlibrarylist": "Koodittoman työnkulun kirjasto",
  "filetype_spnocodeworkflowlibrarylist": "Koodittoman työnkulun kirjasto",
  "spprojecttask": "Projektitehtävä",
  "filetype_spprojecttask": "Projektitehtävä",
  "spprojecttasklist": "Projektitehtävät",
  "filetype_spprojecttasklist": "Projektitehtävät",
  "sppublishingpageslibrarylist": "Sivujen kirjasto",
  "filetype_sppublishingpageslibrarylist": "Sivujen kirjasto",
  "spreportdocumentlibrarylist": "Raportin asiakirjakirjasto",
  "filetype_spreportdocumentlibrarylist": "Raportin asiakirjakirjasto",
  "spreportlibrarylist": "Raporttikirjasto",
  "filetype_spreportlibrarylist": "Raporttikirjasto",
  "spslidelibrarylist": "Diakuvakirjasto",
  "filetype_spslidelibrarylist": "Diakuvakirjasto",
  "sptab": "Välilehdet",
  "filetype_sptab": "Välilehdet",
  "sptablist": "Välilehtilista",
  "filetype_sptablist": "Välilehtilista",
  "sptranslationmanagementlibrarylist": "Kääntämisen hallinnan kirjasto",
  "filetype_sptranslationmanagementlibrarylist": "Kääntämisen hallinnan kirjasto",
  "spuserinformation": "Käyttäjätiedot",
  "filetype_spuserinformation": "Käyttäjätiedot",
  "spuserinformationlist": "Käyttäjätietojen lista",
  "filetype_spuserinformationlist": "Käyttäjätietojen lista",
  "spwikipagelibrarylist": "Wiki-sivun kirjasto",
  "filetype_spwikipagelibrarylist": "Wiki-sivun kirjasto",
  "spworkflowhistory": "Työnkulkuhistoria",
  "filetype_spworkflowhistory": "Työnkulkuhistoria",
  "spworkflowhistorylist": "Työnkulkuhistorian lista",
  "filetype_spworkflowhistorylist": "Työnkulkuhistorian lista",
  "spworkflowprocess": "Räätälöity työnkulku",
  "filetype_spworkflowprocess": "Räätälöity työnkulku",
  "spworkflowprocesslist": "Räätälöidyt työnkulut",
  "filetype_spworkflowprocesslist": "Räätälöidyt työnkulut",
  "sppublishingimageslibrarylist": "Julkaistujen kuvien kirjasto",
  "filetype_sppublishingimageslibrarylist": "Julkaistujen kuvien kirjasto",
  "spcirculation": "Jakelu",
  "filetype_spcirculation": "Jakelu",
  "spcirculationlist": "Jakelut",
  "filetype_spcirculationlist": "Jakelut",
  "spdashboardslibrarylist": "Koontinäytön kirjasto",
  "filetype_spdashboardslibrarylist": "Koontinäytön kirjasto",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePointi-tietoyhteyksien kirjasto",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePointi-tietoyhteyksien kirjasto",
  "sphealthreport": "Terveysraportti",
  "filetype_sphealthreport": "Terveysraportti",
  "sphealthreportlist": "Terveysraportit",
  "filetype_sphealthreportlist": "Terveysraportit",
  "sphealthrule": "Terveyssääntö",
  "filetype_sphealthrule": "Terveyssääntö",
  "sphealthrulelist": "Terveyssäännöt",
  "filetype_sphealthrulelist": "Terveyssäännöt",
  "spimedictionary": "IME-sanakirja",
  "filetype_spimedictionary": "IME-sanakirja",
  "spimedictionarylist": "IME-sanakirjat",
  "filetype_spimedictionarylist": "IME-sanakirjat",
  "spperformancepointcontent": "PerformancePoint-sisältö",
  "filetype_spperformancepointcontent": "PerformancePoint-sisältö",
  "spperformancepointcontentlist": "PerformancePoint-sisällöt",
  "filetype_spperformancepointcontentlist": "PerformancePoint-sisällöt",
  "spphonecallmemo": "Soitetun puhelun muistio",
  "filetype_spphonecallmemo": "Soitetun puhelun muistio",
  "spphonecallmemolist": "Soitettujen puheluiden muistiot",
  "filetype_spphonecallmemolist": "Soitettujen puheluiden muistiot",
  "sprecordlibrarylist": "Tallennusten kirjasto",
  "filetype_sprecordlibrarylist": "Tallennusten kirjasto",
  "spresource": "Resurssi",
  "filetype_spresource": "Resurssi",
  "spresourcelist": "Resurssit",
  "filetype_spresourcelist": "Resurssit",
  "spprocessdiagramslibrarylist": "Prosessikaavion kirjasto",
  "filetype_spprocessdiagramslibrarylist": "Prosessikaavion kirjasto",
  "spsitethemeslibrarylist": "Sivustoteeman kirjasto",
  "filetype_spsitethemeslibrarylist": "Sivustoteeman kirjasto",
  "spsolutionslibrarylist": "Ratkaisujen kirjasto",
  "filetype_spsolutionslibrarylist": "Ratkaisujen kirjasto",
  "spwfpublibrarylist": "WFPUB-kirjasto",
  "filetype_spwfpublibrarylist": "WFPUB-kirjasto",
  "spwhereabout": "Sijainti",
  "filetype_spwhereabout": "Sijainti",
  "spwhereaboutlist": "Sijainnit",
  "filetype_spwhereaboutlist": "Sijainnit",
  "spdocumentlink": "Linkki asiakirjaan",
  "filetype_spdocumentlink": "Linkki asiakirjaan",
  "spdocumentset": "Asiakirjasetti",
  "filetype_spdocumentset": "Asiakirjasetti",
  "spmicrofeedpost": "Mikrosyötejulkaisu",
  "filetype_spmicrofeedpost": "Mikrosyötejulkaisu",
  "spmicrofeedlist": "Mikrosyöte",
  "filetype_spmicrofeedlist": "Mikrosyöte",
  "splistfolder": "Listakansio",
  "filetype_splistfolder": "Listakansio",
  "Unknown": "Tuntematon",
  "And": "JA",
  "Authenticating": "Varmentaa {0}…",
  "Clear": "Tyhjennä {0}",
  "CompleteQuery": "Täydennä kysely",
  "Exclude": "Poissulje {0}",
  "EnterTag": "Lisää tagi",
  "Next": "Seuraava",
  "Last": "Viimeinen",
  "Link": "Linkki",
  "Or": "TAI",
  "Previous": "Edellinen",
  "QueryDidntMatchAnyDocuments": "Kyselysi ei vastannut mitään asiakirjoja.",
  "QueryException": "Kyselyssäsi on virhe: {0}.",
  "Me": "Minä",
  "Remove": "Poista",
  "Search": "Hae",
  "SearchFor": "Haku kohteelle {0}",
  "ShareQuery": "Jaa kysely",
  "Preferences": "Asetukset",
  "LinkOpeningSettings": "Linkin avausasetukset",
  "Reauthenticate": "Varmenna uudestaan {0}",
  "ResultsFilteringExpression": "Tulosten suodatusilmaisut",
  "FiltersInYourPreferences": "Suodattaa asetuksiisi",
  "Create": "Luo",
  "SearchIn": "Hae kohteessa {0}",
  "Seconds": "{0} sekunnissa",
  "ShowingResultsOf": "<sn>Tulos</sn><pl>Tulokset</pl> {0}<pl>–{1}</pl> / {2}",
  "ShowingResultsOfWithQuery": "<sn>Tulos</sn><pl>Tulokset</pl> {0}<pl>–{1}</pl> / {2} sta {3}",
  "SwitchTo": "Vaihda kohteeseen {0}",
  "Unexclude": "Sisällytä {0}",
  "ClearAllFilters": "Tyhjennä kaikki suodattimet",
  "SkipLogin": "Ohita kirjautuminen",
  "LoginInProgress": "Kirjautuminen käynnissä, odota",
  "Login": "Kirjaudu sisään",
  "GetStarted": "Aloita",
  "More": "Lisää",
  "NMore": "{0} lisää…",
  "Less": "Vähemmän",
  "Settings": "Asetukset",
  "Score": "Pistemäärä",
  "ScoreDescription": "Pistemäärä lasketaan esiintymisten määrästä sekä sijainnista tulosasetuksessa.",
  "Occurrences": "Esiintymiset",
  "OccurrencesDescription": "Lajittele esiintymismäärän mukaan, siten että arvot, joiden määrä on suurin, tulevat ensin.",
  "Label": "Merkki",
  "Of": "/",
  "LabelDescription": "Lajittele aakkosjärjestyksessä kenttäarvojen perusteella.",
  "Value": "Arvo",
  "ValueDescription": "Lajittele ensimmäisenä lasketun kentän arvojen perusteella",
  "AlphaAscending": "Nouseva arvo",
  "AlphaDescending": "Laskeva arvo",
  "ChiSquare": "Khiin neliö",
  "Nosort": "Ei lajittelua",
  "NosortDescription": "Älä järjestä arvoja. Arvot palautuvat satunnaiseen järjestykseen.",
  "RelativeFrequency": "Suhteellinen tiheys",
  "RelativeFrequencyDescription": "Lajittele arvojen suhteellisen tiheyden perusteella. Vähiten yleiset arvot tulevat ylempänä.",
  "DateDistribution": "Päivämäärän jako",
  "Custom": "Räätälöity",
  "CustomDescription": "Lajittele räätälöidyn järjestyksen perusteella",
  "ComputedField": "Laskettu kenttä",
  "Ascending": "Nouseva",
  "Descending": "Laskeva",
  "noResultFor": "Ei tuloksia kohteelle {0}",
  "autoCorrectedQueryTo": "Kysely korjattiin automaattisesti kohteeseen {0}",
  "didYouMean": "Tarkoititko: {0}",
  "SuggestedResults": "Ehdotetut tulokset",
  "SuggestedQueries": "Ehdotetut kyselyt",
  "MostRelevantItems": "Merkityksellisimmät kohteet:",
  "AllItems": "Kaikki kohteet:",
  "ShowLess": "Näytä vähemmän",
  "ShowMore": "Näytä enemmän",
  "HideFacet": "Piilota fasetti",
  "ShowFacet": "Näytä fasetti",
  "AndOthers": "ja {0} muu<pl>ta</pl>",
  "Others": "{0} muu<pl>ta</pl>",
  "MostRelevantPosts": "Merkityksellisimmät postaukset:",
  "CompleteThread": "Täydennä ketju:",
  "ShowCompleteThread": "Näytä täysi ketju",
  "ShowOnlyTopMatchingPosts": "Näytä vain parhaiten sopivat postaukset",
  "MostRelevantReplies": "Merkityksellisimmät vastaukset:",
  "AllConversation": "Koko keskustelu:",
  "ShowAllConversation": "Näytä koko keskustelu",
  "ShowAllReplies": "Näytä kaikki vastaukset",
  "ShowOnlyMostRelevantReplies": "Näytä vain merkityksellisimmät vastaukset",
  "Close": "Sulje",
  "Open": "Avaa",
  "OpenInOutlookWhenPossible": "Avaa Outlook (kun mahdollista)",
  "AlwaysOpenInNewWindow": "Avaa aina tulokset uudessa ikkunassa",
  "Quickview": "Pikanäkymä",
  "NoQuickview": "Asiakirjan pikanäkymä ei ole saatavilla",
  "ErrorReport": "Virheraportti",
  "OopsError": "Jotain meni pieleen palvelimella.",
  "ProblemPersists": "Jos ongelma ei poistu, ota yhteyttä ylläpitoon.",
  "GoBack": "Siirry takaisin",
  "Reset": "Nollaa",
  "Retry": "Yritä uudestaan",
  "MoreInfo": "Lisätietoja",
  "Username": "Käyttäjätunnus",
  "Password": "Salasana",
  "PostedBy": "Julkaisija:",
  "CannotConnect": "Palvelinosoitteeseen ei pysty muodostamaan yhteyttä.",
  "BadUserPass": "Salasana ei vastaa käyttäjätunnusta.",
  "PleaseEnterYourCredentials": "Syötä tunnistetietosi järjestelmälle {0}.",
  "PleaseEnterYourSearchPage": "Syötä hakusivusi URL",
  "Collapse": "Pienennä",
  "Collapsable": "Pienennettävä",
  "Expand": "Laajenna",
  "Today": "Tänään",
  "Yesterday": "Eilen",
  "Tomorrow": "Huomenna",
  "Duration": "Kesto: {0}",
  "IndexDuration": "Hakemiston kesto: {0}",
  "ProxyDuration": "Välityspalvelimen kesto: {0}",
  "ClientDuration": "Asiakkaan kesto: {0}",
  "Unavailable": "Ei saatavissa",
  "Reply": "Vastaa",
  "ReplyAll": "Vastaa kaikille",
  "Forward": "Välitä eteenpäin",
  "From": "Lähettäjä",
  "Caption": "Kuvateksti",
  "Expression": "Ilmaisu",
  "Tab": "Välilehti",
  "Tabs": "Välilehdet",
  "EnterExpressionName": "Syötä ilmaisun nimi",
  "EnterExpressionToFilterWith": "Syötä ilmaisu suodattaaksesi tulokset",
  "SelectTab": "Valitse välilehti",
  "SelectAll": "Valitse kaikki",
  "PageUrl": "Hakusivu URL",
  "ErrorSavingToDevice": "Virhe tietojen tallennuksessa laitteellesi",
  "ErrorReadingFromDevice": "Virhe tietoja luettaessa laitteeltasi",
  "AppIntro": "Puhu tuoteasiantuntijan kanssa, joka pystyy vastaamaan kysymyksiisi   Coveosta ja auttamaan sinua päättämään, mikä Coveo-ratkaisu on oikea sinulle. Kokeile live-demoa!",
  "TryDemo": "Kokeile demoa",
  "ContactUs": "Ota meihin yhteyttä",
  "NewToCoveo": "Uusi Coveossa?",
  "LetUsHelpGetStarted": "Anna meidän auttaa sinut alkuun",
  "LikesThis": "{0} <pl>pitävät</pl><sn>pitää</sn> tästä.",
  "CannotConnectSearchPage": "Hakusivullesi ei pystytä yhdistämään",
  "AreYouSureDeleteFilter": "Oletko varma, että haluat poistaa suodattimen {0} ilmaisulla {1}",
  "OnlineHelp": "Verkkotuki",
  "Done": "Valmis",
  "SaveFacetState": "Tallenna tämä fasettitila",
  "ClearFacetState": "Tyhjennä fasettitila",
  "DisplayingTheOnlyMessage": "Näyttää ainoan viestin tässä keskustelussa",
  "NoNetworkConnection": "Ei verkkoyhteyttä",
  "UnknownConnection": "Tuntematon yhteys",
  "EthernetConnection": "Ethernet-yhteys",
  "WiFi": "WiFi-yhteys",
  "CELL": "Mobiiliyhteys",
  "CELL_2G": "2G-mobiiliyhteys",
  "CELL_3G": "3G-mobiiliyhteys",
  "CELL_4G": "4G-mobiiliyhteys",
  "Relevance": "Merkitys",
  "Date": "Päivämäärä",
  "Amount": "Määrä",
  "QueryExceptionNoException": "Ei poikkeusta",
  "QueryExceptionInvalidSyntax": "Virheellinen syntaksi",
  "QueryExceptionInvalidCustomField": "Virheellinen räätälöity kenttä",
  "QueryExceptionInvalidDate": "Virheellinen päivämäärä",
  "QueryExceptionInvalidExactPhrase": "Virheellinen tarkka lauseke",
  "QueryExceptionInvalidDateOp": "Virheellinen päiväyskäyttäjä",
  "QueryExceptionInvalidNear": "Virheellinen NEAR-käyttäjä",
  "QueryExceptionInvalidWeightedNear": "Virheellinen painotettu NEAR",
  "QueryExceptionInvalidTerm": "Virheellinen termi",
  "QueryExceptionTooManyTerms": "Liian monta termiä",
  "QueryExceptionWildcardTooGeneral": "Liian yleinen villikortti",
  "QueryExceptionInvalidSortField": "Virheellinen lajittelukenttä",
  "QueryExceptionInvalidSmallStringOp": "Virheellinen pienen jonon käyttäjä",
  "QueryExceptionRequestedResultsMax": "Pyydettyjä tuloksia enintään",
  "QueryExceptionAggregatedMirrorDead": "Koottu peili on pois verkosta",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Kootun peilin kyselyn aikakatkaisu",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Kootun peilin virheellinen rakennusnumero",
  "QueryExceptionAggregatedMirrorCannotConnect": "Koottuun peiliin ei voida yhdistää",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Ei tarpeeksi johtavan merkin villikortteja",
  "QueryExceptionSecurityInverterNotFound": "Turvallisuusmuunninta ei löytynyt",
  "QueryExceptionSecurityInverterAccessDenied": "Turvallisuusmuuntimen käyttöoikeus kielletty",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Koottu peili ei pysty esiintymään toisena",
  "QueryExceptionUnexpected": "Odottamaton",
  "QueryExceptionAccessDenied": "Käyttöoikeus kielletty",
  "QueryExceptionSuperUserTokenInvalid": "Superkäyttäjän merkki virheellinen",
  "QueryExceptionSuperUserTokenExpired": "Superkäyttäjän merkki vanhentunut",
  "QueryExceptionLicenseQueriesExpired": "Kyselyjen lisenssi vanhentunut",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Lisenssiä superkäyttäjän merkille ei tueta",
  "QueryExceptionInvalidSession": "Virheellinen istunto",
  "QueryExceptionInvalidDocument": "Virheellinen asiakirja",
  "QueryExceptionSearchDisabled": "Haku poistettu käytöstä",
  "FileType": "Tiedostotyyppi",
  "ShowAttachment": "Näytä liite",
  "OnFeed": "{0}:n syötteestä.",
  "Author": "Tekijä",
  "NoTitle": "Ei otsikkoa",
  "CurrentSelections": "Nykyiset valinnat",
  "AllContent": "Koko sisältö",
  "CancelLastAction": "Peruuta viimeinen toiminta",
  "SearchTips": "Hakuvihjeet",
  "CheckSpelling": "Tarkasta asiasanojen kirjoitusasu.",
  "TryUsingFewerKeywords": "Kokeile käyttää vähemmän, erilaisia tai yleisempiä asiasanoja.",
  "SelectFewerFilters": "Valitse vähemmän suodattimia hakusi laajentamiseksi.",
  "Document": "Asiakirja",
  "Time": "Aika",
  "StartDate": "Aloituspäivä",
  "StartTime": "Aloitusaika",
  "DurationTitle": "Kesto",
  "UserQuery": "Käyttäjäkysely",
  "ShowUserActions": "Näytä käyttäjän toiminta",
  "NoData": "Tietoja ei saatavilla",
  "EventType": "Tapahtumatyyppi",
  "GoToFullSearch": "Täysi haku",
  "GoToEdition": "Räätälöi paneeli",
  "RemoveContext": "Poista konteksti",
  "BoxAttachToCase": "Liitä pyyntöön",
  "AttachToCase": "Liitä pyyntöön",
  "Attach": "Liitä",
  "Attached": "Liitetty",
  "Detach": "Irrota",
  "Details": "Tietoja",
  "AdditionalFilters": "Lisäsuodattimet",
  "SelectNonContextualSearch": "Poista konteksti tämänhetkisestä kirjauksesta laajentaaksesi hakua",
  "CopyPasteToSupport": "Kopioi ja liitä tämä viesti lisätiedoksi Coveon tukitiimille.",
  "FollowQueryDescription": "Ilmoita minulle tämän kyselyn hakutulosten muutoksista.",
  "SearchAlerts_Panel": "Hallitse hälytyksiä",
  "SearchAlerts_PanelDescription": "Tarkastele ja hallinnoi hakuhälytyksiä.",
  "SearchAlerts_PanelNoSearchAlerts": "Sinulla ei ole tilauksia.",
  "SearchAlerts_Fail": "Hakuhälytysten palvelu ei ole tällä hetkellä käytettävissä.",
  "SearchAlerts_Type": "Tyyppi",
  "SearchAlerts_Content": "Sisältö",
  "SearchAlerts_Actions": "Toiminta",
  "EmptyQuery": "<tyhjä>",
  "SearchAlerts_Type_followQuery": "Kysely",
  "SearchAlerts_Type_followDocument": "Kohta",
  "SearchAlerts_unFollowing": "Lopeta seuraaminen",
  "SearchAlerts_follow": "Seuraa",
  "SearchAlerts_followed": "Seurattu",
  "SearchAlerts_followQuery": "Seuraa kyselyä",
  "Subscription_StopFollowingQuery": "Lopeta kyselyn seuraaminen",
  "SearchAlerts_Frequency": "Kun",
  "SubscriptionsManageSubscriptions": "Hallitse hälytyksiä",
  "SubscriptionsMessageFollowQuery": "Saat hälytyksiä, kun kysely <b>{0}</b> uudistetaan tai sitä päivitetään.",
  "SubscriptionsMessageFollow": "Saat hälytyksiä muutoksista kohteelle <b>{0}</b>.",
  "Expiration": "Umpeutuminen",
  "Monthly": "Kuukausittain",
  "Daily": "Päivittäin",
  "Monday": "Maanantai",
  "Tuesday": "Tiistai",
  "Wednesday": "Keskiviikko",
  "Thursday": "Torstai",
  "Friday": "Perjantai",
  "Saturday": "Lauantai",
  "Sunday": "Sunnuntai",
  "NextDay": "Seuraava {0}",
  "LastDay": "Viime {0}",
  "StartTypingCaseForSuggestions": "Kuvaile ongelmaasi nähdäksesi mahdollisia ratkaisuja",
  "ExportToExcel": "Tuo Exceliin",
  "ExportToExcelDescription": "Tuo hakutulokset Exceliin",
  "CaseCreationNoResults": "Suositeltuja ratkaisuja ei löytynyt",
  "SortBy": "Lajittelutapa",
  "BoxCreateArticle": "Luo artikkeli",
  "Facets": "Fasetit",
  "AdvancedSearch": "Tarkennettu haku",
  "Keywords": "Avainsanat",
  "AllTheseWords": "Kaikki nämä sanat",
  "ExactPhrase": "Sanatarkasti tämä lause",
  "AnyOfTheseWords": "Mikä tahansa näistä sanoista",
  "NoneOfTheseWords": "Mikään näistä sanoista",
  "Anytime": "Milloin tahansa",
  "InTheLast": "Viimeisessä",
  "Days": "päivää",
  "Months": "kuukautta",
  "Month": "Kuukausi",
  "Year": "Vuosi",
  "Between": "Välillä",
  "Language": "Kieli",
  "Size": "Koko",
  "AtLeast": "vähintään",
  "AtMost": "enintään",
  "Contains": "sisältää",
  "DoesNotContain": "ei sisällä",
  "Matches": "vastaa",
  "Bytes": "tavua",
  "card": "Kortti",
  "table": "Taulukko",
  "ResultLinks": "Tuloslinkit",
  "EnableQuerySyntax": "Salli kyselyn syntaksi",
  "On": "Päällä",
  "Off": "Poispäältä",
  "Automatic": "Automaattinen",
  "ResultsPerPage": "Tuloksia per sivu",
  "PreviousMonth": "Edellinen kuukausi",
  "NextMonth": "Seuraava kuukausi",
  "Title": "Otsikko",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["fi"] = merge(locales["fi"], dict);
  String["toLocaleString"].call(this, { "fi": dict });
  String["locale"] = "fi";
  String["defaultLocale"] = "en";
  Globalize.culture("fi")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "Käyttäjä",
  "filetype_box user": "Käyttäjä",
  "html": "HTML-tiedosto",
  "filetype_html": "HTML-tiedosto",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Verkkosivu",
  "filetype_webscraperwebpage": "Verkkosivu",
  "image": "Kuva",
  "filetype_image": "Kuva",
  "folder": "Kansio",
  "filetype_folder": "Kansio",
  "txt": "Teksti",
  "filetype_txt": "Teksti",
  "zip": "Zip-tiedosto",
  "filetype_zip": "Zip-tiedosto",
  "olefile": "OLE-tiedosto",
  "filetype_olefile": "OLE-tiedosto",
  "gmailmessage": "Gmail-viesti",
  "filetype_gmailmessage": "Gmail-viesti",
  "pdf": "PDF-tiedosto",
  "filetype_pdf": "PDF-tiedosto",
  "swf": "Flash-tiedosto",
  "filetype_swf": "Flash-tiedosto",
  "xml": "XML-tiedosto",
  "filetype_xml": "XML-tiedosto",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS-syöte",
  "filetype_rssitem": "RSS-syöte",
  "doc": "Asiakirja",
  "filetype_doc": "Asiakirja",
  "docx": "Microsoft Word -asiakirja",
  "filetype_docx": "Microsoft Word -asiakirja",
  "xls": "Laskentataulukkotiedosto",
  "filetype_xls": "Laskentataulukkotiedosto",
  "ppt": "Esitystiedosto",
  "filetype_ppt": "Esitystiedosto",
  "video": "Video",
  "filetype_video": "Video",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Text -tiedosto",
  "filetype_odt": "Open Text -tiedosto",
  "lithiummessage": "Lithium-viesti",
  "filetype_lithiummessage": "Lithium-viesti",
  "lithiumthread": "Lithium-viestiketju",
  "filetype_lithiumthread": "Lithium-viestiketju",
  "lithiumboard": "Lithium-elektroninen taulu",
  "filetype_lithiumboard": "Lithium-elektroninen taulu",
  "lithiumcategory": "Lithium-kategoria",
  "filetype_lithiumcategory": "Lithium-kategoria",
  "lithiumcommunity": "Lithium-yhteisö",
  "filetype_lithiumcommunity": "Lithium-yhteisö",
  "people": "Käyttäjä",
  "objecttype_people": "Käyttäjä",
  "message": "Viesti",
  "objecttype_message": "Viesti",
  "feed": "RSS-syöte",
  "objecttype_feed": "RSS-syöte",
  "thread": "Viestiketju",
  "objecttype_thread": "Viestiketju",
  "file": "Tiedosto",
  "objecttype_file": "Tiedosto",
  "board": "Taulukko",
  "objecttype_board": "Taulukko",
  "category": "Kategoria",
  "objecttype_category": "Kategoria",
  "account": "Tili",
  "objecttype_account": "Tili",
  "annotation": "Huomautus",
  "objecttype_annotation": "Huomautus",
  "campaign": "Kampanja",
  "objecttype_campaign": "Kampanja",
  "case": "Tapaus",
  "objecttype_case": "Tapaus",
  "contact": "Yhteydenotto",
  "objecttype_contact": "Yhteydenotto",
  "contract": "Sopimus",
  "objecttype_contract": "Sopimus",
  "event": "Tapahtuma",
  "objecttype_event": "Tapahtuma",
  "email": "Sähköposti",
  "objecttype_email": "Sähköposti",
  "goal": "Tavoite",
  "objecttype_goal": "Tavoite",
  "objecttype_incident": "Tapaus",
  "invoice": "Lasku",
  "objecttype_invoice": "Lasku",
  "lead": "Johto",
  "objecttype_lead": "Johto",
  "list": "Lista",
  "objecttype_list": "Markkinointilista",
  "solution": "Ratkaisu",
  "objecttype_solution": "Ratkaisu",
  "task": "Tehtävä",
  "objecttype_task": "Tehtävä",
  "user": "Käyttäjä",
  "objecttype_user": "Käyttäjä",
  "attachment": "Liite",
  "objecttype_attachment": "Liite",
  "casecomment": "Tapauskommentti",
  "objecttype_casecomment": "Tapauskommentti",
  "opportunity": "Mahdollisuus",
  "objecttype_opportunity": "Mahdollisuus",
  "opportunityproduct": "Tuotemahdollisuus",
  "objecttype_opportunityproduct": "Tuotemahdollisuus",
  "feeditem": "Jutustelu",
  "objecttype_feeditem": "Jutustelu",
  "feedcomment": "Jutustelu",
  "objecttype_feedcomment": "Jutustelu",
  "note": "Huomautus",
  "objecttype_note": "Huomautus",
  "product": "Tuote",
  "objecttype_product": "Tuote",
  "partner": "Kumppani",
  "objecttype_partner": "Kumppani",
  "queueitem": "Jonotuskohde",
  "objecttype_queueitem": "Jonotuskohde",
  "quote": "Tarjous",
  "objecttype_quote": "Tarjous",
  "salesliterature": "Mainosesite",
  "objecttype_salesliterature": "Mainosesite",
  "salesorder": "Tilaus",
  "objecttype_salesorder": "Tilaus",
  "service": "Palvelu",
  "objecttype_service": "Palvelu",
  "socialprofile": "Sosiaalinen profiili",
  "objecttype_socialprofile": "Sosiaalinen profiili",
  "kbdocumentation": "Dokumentaatio",
  "objecttype_kbdocumentation": "Dokumentaatio",
  "kbtechnicalarticle": "Dokumentaatio",
  "objecttype_kbtechnicalarticle": "Dokumentaatio",
  "kbsolution": "Ratkaisu",
  "objecttype_kbsolution": "Ratkaisu",
  "kbknowledgearticle": "Tietoartikkeli",
  "objecttype_kbknowledgearticle": "Tietoartikkeli",
  "kbattachment": "Liite",
  "objecttype_kbattachment": "Liite",
  "kbarticle": "Artikkeli",
  "objecttype_kbarticle": "Artikkeli",
  "kbarticlecomment": "Artikkelin kommentti",
  "objecttype_kbarticlecomment": "Artikkelin kommentti",
  "knowledgearticle": "Tietoartikkeli",
  "objecttype_knowledgearticle": "Tietoartikkeli",
  "topic": "Aihe",
  "objecttype_topic": "Aihe",
  "dashboard": "Koontinäyttö",
  "objecttype_dashboard": "Koontinäyttö",
  "contentversion": "Asiakirja",
  "objecttype_contentversion": "Asiakirja",
  "collaborationgroup": "Yhteistyöryhmä",
  "objecttype_collaborationgroup": "Yhteistyöryhmä",
  "spportal": "Portaali",
  "filetype_spportal": "Portaali",
  "spsite": "Sivusto",
  "filetype_spsite": "Sivusto",
  "spuserprofile": "SharePoint-käyttäjä",
  "filetype_spuserprofile": "SharePoint-käyttäjä",
  "sparea": "Alue",
  "filetype_sparea": "Alue",
  "spannouncement": "Ilmoitus",
  "filetype_spannouncement": "Ilmoitus",
  "spannouncementlist": "Ilmoitukset",
  "filetype_spannouncementlist": "Ilmoitukset",
  "spcontact": "Yhteydenotto",
  "filetype_spcontact": "Yhteydenotto",
  "spcontactlist": "Yhteyshenkilöt",
  "filetype_spcontactlist": "Yhteyshenkilöt",
  "spcustomlist": "Räätälöity lista",
  "filetype_spcustomlist": "Räätälöity lista",
  "spdiscussionboard": "Keskustelufoorumi",
  "filetype_spdiscussionboard": "Keskustelufoorumi",
  "spdiscussionboardlist": "Keskustelufoorumit",
  "filetype_spdiscussionboardlist": "Keskustelufoorumit",
  "spdocumentlibrarylist": "Asiakirjakirjasto",
  "filetype_spdocumentlibrarylist": "Asiakirjakirjasto",
  "spevent": "Tapahtuma",
  "filetype_spevent": "Tapahtuma",
  "speventlist": "Tapahtumat",
  "filetype_speventlist": "Tapahtumat",
  "spformlibrarylist": "Lomakekirjasto",
  "filetype_spformlibrarylist": "Lomakekirjasto",
  "spissue": "Ongelma",
  "filetype_spissue": "Ongelma",
  "spissuelist": "Ongelmat",
  "filetype_spissuelist": "Ongelmat",
  "splink": "Linkki",
  "filetype_splink": "Linkki",
  "splinklist": "Linkit",
  "filetype_splinklist": "Linkit",
  "sppicturelibrarylist": "Kuvakirjasto",
  "filetype_sppicturelibrarylist": "Kuvakirjasto",
  "spsurvey": "Kysely",
  "filetype_spsurvey": "Kysely",
  "spsurveylist": "Kyselyt",
  "filetype_spsurveylist": "Kyselyt",
  "sptask": "Tehtävä",
  "filetype_sptask": "Tehtävä",
  "sptasklist": "Tehtävät",
  "filetype_sptasklist": "Tehtävät",
  "spagenda": "Päiväohjelma",
  "filetype_spagenda": "Päiväohjelma",
  "spagendalist": "Päiväohjelmat",
  "filetype_spagendalist": "Päiväohjelmat",
  "spattendee": "Osallistuja",
  "filetype_spattendee": "Osallistuja",
  "spattendeelist": "Osallistujat",
  "filetype_spattendeelist": "Osallistujat",
  "spcustomgridlist": "Räätälöity taulukko",
  "filetype_spcustomgridlist": "Räätälöity taulukko",
  "spdecision": "Päätös",
  "filetype_spdecision": "Päätös",
  "spdecisionlist": "Päätökset",
  "filetype_spdecisionlist": "Päätökset",
  "spobjective": "Tavoite",
  "filetype_spobjective": "Tavoite",
  "spobjectivelist": "Tavoitteet",
  "filetype_spobjectivelist": "Tavoitteet",
  "sptextbox": "Tekstiruutu",
  "filetype_sptextbox": "Tekstiruutu",
  "sptextboxlist": "Tekstiruutulista",
  "filetype_sptextboxlist": "Tekstiruutulista",
  "spthingstobring": "Tuotava asia",
  "filetype_spthingstobring": "Tuotava asia",
  "spthingstobringlist": "Tuotavat asiat",
  "filetype_spthingstobringlist": "Tuotavat asiat",
  "sparealisting": "Aluelistaus",
  "filetype_sparealisting": "Aluelistaus",
  "spmeetingserie": "Tapaamissarja",
  "filetype_spmeetingserie": "Tapaamissarja",
  "spmeetingserielist": "Tapaamissarjan lista",
  "filetype_spmeetingserielist": "Tapaamissarjan lista",
  "spsitedirectory": "Sivuston hakemiston kohde",
  "filetype_spsitedirectory": "Sivuston hakemiston kohde",
  "spsitedirectorylist": "Sivuston hakemisto",
  "filetype_spsitedirectorylist": "Sivuston hakemisto",
  "spdatasource": "Tietolähde",
  "filetype_spdatasource": "Tietolähde",
  "spdatasourcelist": "Tietolähdelista",
  "filetype_spdatasourcelist": "Tietolähdelista",
  "splisttemplatecataloglist": "Mallilistan galleria",
  "filetype_splisttemplatecataloglist": "Mallilistan galleria",
  "spwebpartcataloglist": "WebPart-galleria",
  "filetype_spwebpartcataloglist": "WebPart-galleria",
  "spwebtemplatecataloglist": "Sivustomallin galleria",
  "filetype_spwebtemplatecataloglist": "Sivustomallin galleria",
  "spworkspacepagelist": "Työtilan sivut",
  "filetype_spworkspacepagelist": "Työtilan sivut",
  "spunknownlist": "Räätälöity lista",
  "filetype_spunknownlist": "Räätälöity lista",
  "spadministratortask": "Järjestelmänvalvojan tehtävä",
  "filetype_spadministratortask": "Järjestelmänvalvojan tehtävä",
  "spadministratortasklist": "Järjestelmänvalvojan tehtävät",
  "filetype_spadministratortasklist": "Järjestelmänvalvojan tehtävät",
  "spareadocumentlibrarylist": "Alueen asiakirjakirjasto",
  "filetype_spareadocumentlibrarylist": "Alueen asiakirjakirjasto",
  "spblogcategory": "Blogikategoria",
  "filetype_spblogcategory": "Blogikategoria",
  "spblogcategorylist": "Blogikategoriat",
  "filetype_spblogcategorylist": "Blogikategoriat",
  "spblogcomment": "Blogikommentti",
  "filetype_spblogcomment": "Blogikommentti",
  "spblogcommentlist": "Blogikommentit",
  "filetype_spblogcommentlist": "Blogikommentit",
  "spblogpost": "Blogijulkaisu",
  "filetype_spblogpost": "Blogijulkaisu",
  "spblogpostlist": "Blogijulkaisut",
  "filetype_spblogpostlist": "Blogijulkaisut",
  "spdataconnectionlibrarylist": "Tietoyhteyksien kirjasto",
  "filetype_spdataconnectionlibrarylist": "Tietoyhteyksien kirjasto",
  "spdistributiongroup": "Jakeluryhmä",
  "filetype_spdistributiongroup": "Jakeluryhmä",
  "spdistributiongrouplist": "Jakeluryhmät",
  "filetype_spdistributiongrouplist": "Jakeluryhmät",
  "spipfslist": "InfoPath-lomakkeiden palvelimet",
  "filetype_spipfslist": "InfoPath-lomakkeiden palvelimet",
  "spkeyperformanceindicator": "Avainsuorituksen ilmaisin",
  "filetype_spkeyperformanceindicator": "Avainsuorituksen ilmaisin",
  "spkeyperformanceindicatorlist": "Avainsuoritusten ilmaisimet",
  "filetype_spkeyperformanceindicatorlist": "Avainsuoritusten ilmaisimet",
  "splanguagesandtranslator": "Kielet ja kääntäjä",
  "filetype_splanguagesandtranslator": "Kielet ja kääntäjä",
  "splanguagesandtranslatorlist": "Kielet ja kääntäjät",
  "filetype_splanguagesandtranslatorlist": "Kielet ja kääntäjät",
  "spmasterpagescataloglist": "Pääsivun galleria",
  "filetype_spmasterpagescataloglist": "Pääsivun galleria",
  "spnocodeworkflowlibrarylist": "Koodittoman työnkulun kirjasto",
  "filetype_spnocodeworkflowlibrarylist": "Koodittoman työnkulun kirjasto",
  "spprojecttask": "Projektitehtävä",
  "filetype_spprojecttask": "Projektitehtävä",
  "spprojecttasklist": "Projektitehtävät",
  "filetype_spprojecttasklist": "Projektitehtävät",
  "sppublishingpageslibrarylist": "Sivujen kirjasto",
  "filetype_sppublishingpageslibrarylist": "Sivujen kirjasto",
  "spreportdocumentlibrarylist": "Raportin asiakirjakirjasto",
  "filetype_spreportdocumentlibrarylist": "Raportin asiakirjakirjasto",
  "spreportlibrarylist": "Raporttikirjasto",
  "filetype_spreportlibrarylist": "Raporttikirjasto",
  "spslidelibrarylist": "Diakuvakirjasto",
  "filetype_spslidelibrarylist": "Diakuvakirjasto",
  "sptab": "Välilehdet",
  "filetype_sptab": "Välilehdet",
  "sptablist": "Välilehtilista",
  "filetype_sptablist": "Välilehtilista",
  "sptranslationmanagementlibrarylist": "Kääntämisen hallinnan kirjasto",
  "filetype_sptranslationmanagementlibrarylist": "Kääntämisen hallinnan kirjasto",
  "spuserinformation": "Käyttäjätiedot",
  "filetype_spuserinformation": "Käyttäjätiedot",
  "spuserinformationlist": "Käyttäjätietojen lista",
  "filetype_spuserinformationlist": "Käyttäjätietojen lista",
  "spwikipagelibrarylist": "Wiki-sivun kirjasto",
  "filetype_spwikipagelibrarylist": "Wiki-sivun kirjasto",
  "spworkflowhistory": "Työnkulkuhistoria",
  "filetype_spworkflowhistory": "Työnkulkuhistoria",
  "spworkflowhistorylist": "Työnkulkuhistorian lista",
  "filetype_spworkflowhistorylist": "Työnkulkuhistorian lista",
  "spworkflowprocess": "Räätälöity työnkulku",
  "filetype_spworkflowprocess": "Räätälöity työnkulku",
  "spworkflowprocesslist": "Räätälöidyt työnkulut",
  "filetype_spworkflowprocesslist": "Räätälöidyt työnkulut",
  "sppublishingimageslibrarylist": "Julkaistujen kuvien kirjasto",
  "filetype_sppublishingimageslibrarylist": "Julkaistujen kuvien kirjasto",
  "spcirculation": "Jakelu",
  "filetype_spcirculation": "Jakelu",
  "spcirculationlist": "Jakelut",
  "filetype_spcirculationlist": "Jakelut",
  "spdashboardslibrarylist": "Koontinäytön kirjasto",
  "filetype_spdashboardslibrarylist": "Koontinäytön kirjasto",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePointi-tietoyhteyksien kirjasto",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePointi-tietoyhteyksien kirjasto",
  "sphealthreport": "Terveysraportti",
  "filetype_sphealthreport": "Terveysraportti",
  "sphealthreportlist": "Terveysraportit",
  "filetype_sphealthreportlist": "Terveysraportit",
  "sphealthrule": "Terveyssääntö",
  "filetype_sphealthrule": "Terveyssääntö",
  "sphealthrulelist": "Terveyssäännöt",
  "filetype_sphealthrulelist": "Terveyssäännöt",
  "spimedictionary": "IME-sanakirja",
  "filetype_spimedictionary": "IME-sanakirja",
  "spimedictionarylist": "IME-sanakirjat",
  "filetype_spimedictionarylist": "IME-sanakirjat",
  "spperformancepointcontent": "PerformancePoint-sisältö",
  "filetype_spperformancepointcontent": "PerformancePoint-sisältö",
  "spperformancepointcontentlist": "PerformancePoint-sisällöt",
  "filetype_spperformancepointcontentlist": "PerformancePoint-sisällöt",
  "spphonecallmemo": "Soitetun puhelun muistio",
  "filetype_spphonecallmemo": "Soitetun puhelun muistio",
  "spphonecallmemolist": "Soitettujen puheluiden muistiot",
  "filetype_spphonecallmemolist": "Soitettujen puheluiden muistiot",
  "sprecordlibrarylist": "Tallennusten kirjasto",
  "filetype_sprecordlibrarylist": "Tallennusten kirjasto",
  "spresource": "Resurssi",
  "filetype_spresource": "Resurssi",
  "spresourcelist": "Resurssit",
  "filetype_spresourcelist": "Resurssit",
  "spprocessdiagramslibrarylist": "Prosessikaavion kirjasto",
  "filetype_spprocessdiagramslibrarylist": "Prosessikaavion kirjasto",
  "spsitethemeslibrarylist": "Sivustoteeman kirjasto",
  "filetype_spsitethemeslibrarylist": "Sivustoteeman kirjasto",
  "spsolutionslibrarylist": "Ratkaisujen kirjasto",
  "filetype_spsolutionslibrarylist": "Ratkaisujen kirjasto",
  "spwfpublibrarylist": "WFPUB-kirjasto",
  "filetype_spwfpublibrarylist": "WFPUB-kirjasto",
  "spwhereabout": "Sijainti",
  "filetype_spwhereabout": "Sijainti",
  "spwhereaboutlist": "Sijainnit",
  "filetype_spwhereaboutlist": "Sijainnit",
  "spdocumentlink": "Linkki asiakirjaan",
  "filetype_spdocumentlink": "Linkki asiakirjaan",
  "spdocumentset": "Asiakirjasetti",
  "filetype_spdocumentset": "Asiakirjasetti",
  "spmicrofeedpost": "Mikrosyötejulkaisu",
  "filetype_spmicrofeedpost": "Mikrosyötejulkaisu",
  "spmicrofeedlist": "Mikrosyöte",
  "filetype_spmicrofeedlist": "Mikrosyöte",
  "splistfolder": "Listakansio",
  "filetype_splistfolder": "Listakansio",
  "Unknown": "Tuntematon",
  "And": "JA",
  "Authenticating": "Varmentaa {0}…",
  "Clear": "Tyhjennä {0}",
  "CompleteQuery": "Täydennä kysely",
  "Exclude": "Poissulje {0}",
  "EnterTag": "Lisää tagi",
  "Next": "Seuraava",
  "Last": "Viimeinen",
  "Link": "Linkki",
  "Or": "TAI",
  "Previous": "Edellinen",
  "QueryDidntMatchAnyDocuments": "Kyselysi ei vastannut mitään asiakirjoja.",
  "QueryException": "Kyselyssäsi on virhe: {0}.",
  "Me": "Minä",
  "Remove": "Poista",
  "Search": "Hae",
  "SearchFor": "Haku kohteelle {0}",
  "ShareQuery": "Jaa kysely",
  "Preferences": "Asetukset",
  "LinkOpeningSettings": "Linkin avausasetukset",
  "Reauthenticate": "Varmenna uudestaan {0}",
  "ResultsFilteringExpression": "Tulosten suodatusilmaisut",
  "FiltersInYourPreferences": "Suodattaa asetuksiisi",
  "Create": "Luo",
  "SearchIn": "Hae kohteessa {0}",
  "Seconds": "{0} sekunnissa",
  "ShowingResultsOf": "<sn>Tulos</sn><pl>Tulokset</pl> {0}<pl>–{1}</pl> / {2}",
  "ShowingResultsOfWithQuery": "<sn>Tulos</sn><pl>Tulokset</pl> {0}<pl>–{1}</pl> / {2} sta {3}",
  "SwitchTo": "Vaihda kohteeseen {0}",
  "Unexclude": "Sisällytä {0}",
  "ClearAllFilters": "Tyhjennä kaikki suodattimet",
  "SkipLogin": "Ohita kirjautuminen",
  "LoginInProgress": "Kirjautuminen käynnissä, odota",
  "Login": "Kirjaudu sisään",
  "GetStarted": "Aloita",
  "More": "Lisää",
  "NMore": "{0} lisää…",
  "Less": "Vähemmän",
  "Settings": "Asetukset",
  "Score": "Pistemäärä",
  "ScoreDescription": "Pistemäärä lasketaan esiintymisten määrästä sekä sijainnista tulosasetuksessa.",
  "Occurrences": "Esiintymiset",
  "OccurrencesDescription": "Lajittele esiintymismäärän mukaan, siten että arvot, joiden määrä on suurin, tulevat ensin.",
  "Label": "Merkki",
  "Of": "/",
  "LabelDescription": "Lajittele aakkosjärjestyksessä kenttäarvojen perusteella.",
  "Value": "Arvo",
  "ValueDescription": "Lajittele ensimmäisenä lasketun kentän arvojen perusteella",
  "AlphaAscending": "Nouseva arvo",
  "AlphaDescending": "Laskeva arvo",
  "ChiSquare": "Khiin neliö",
  "Nosort": "Ei lajittelua",
  "NosortDescription": "Älä järjestä arvoja. Arvot palautuvat satunnaiseen järjestykseen.",
  "RelativeFrequency": "Suhteellinen tiheys",
  "RelativeFrequencyDescription": "Lajittele arvojen suhteellisen tiheyden perusteella. Vähiten yleiset arvot tulevat ylempänä.",
  "DateDistribution": "Päivämäärän jako",
  "Custom": "Räätälöity",
  "CustomDescription": "Lajittele räätälöidyn järjestyksen perusteella",
  "ComputedField": "Laskettu kenttä",
  "Ascending": "Nouseva",
  "Descending": "Laskeva",
  "noResultFor": "Ei tuloksia kohteelle {0}",
  "autoCorrectedQueryTo": "Kysely korjattiin automaattisesti kohteeseen {0}",
  "didYouMean": "Tarkoititko: {0}",
  "SuggestedResults": "Ehdotetut tulokset",
  "SuggestedQueries": "Ehdotetut kyselyt",
  "MostRelevantItems": "Merkityksellisimmät kohteet:",
  "AllItems": "Kaikki kohteet:",
  "ShowLess": "Näytä vähemmän",
  "ShowMore": "Näytä enemmän",
  "HideFacet": "Piilota fasetti",
  "ShowFacet": "Näytä fasetti",
  "AndOthers": "ja {0} muu<pl>ta</pl>",
  "Others": "{0} muu<pl>ta</pl>",
  "MostRelevantPosts": "Merkityksellisimmät postaukset:",
  "CompleteThread": "Täydennä ketju:",
  "ShowCompleteThread": "Näytä täysi ketju",
  "ShowOnlyTopMatchingPosts": "Näytä vain parhaiten sopivat postaukset",
  "MostRelevantReplies": "Merkityksellisimmät vastaukset:",
  "AllConversation": "Koko keskustelu:",
  "ShowAllConversation": "Näytä koko keskustelu",
  "ShowAllReplies": "Näytä kaikki vastaukset",
  "ShowOnlyMostRelevantReplies": "Näytä vain merkityksellisimmät vastaukset",
  "Close": "Sulje",
  "Open": "Avaa",
  "OpenInOutlookWhenPossible": "Avaa Outlook (kun mahdollista)",
  "AlwaysOpenInNewWindow": "Avaa aina tulokset uudessa ikkunassa",
  "Quickview": "Pikanäkymä",
  "NoQuickview": "Asiakirjan pikanäkymä ei ole saatavilla",
  "ErrorReport": "Virheraportti",
  "OopsError": "Jotain meni pieleen palvelimella.",
  "ProblemPersists": "Jos ongelma ei poistu, ota yhteyttä ylläpitoon.",
  "GoBack": "Siirry takaisin",
  "Reset": "Nollaa",
  "Retry": "Yritä uudestaan",
  "MoreInfo": "Lisätietoja",
  "Username": "Käyttäjätunnus",
  "Password": "Salasana",
  "PostedBy": "Julkaisija:",
  "CannotConnect": "Palvelinosoitteeseen ei pysty muodostamaan yhteyttä.",
  "BadUserPass": "Salasana ei vastaa käyttäjätunnusta.",
  "PleaseEnterYourCredentials": "Syötä tunnistetietosi järjestelmälle {0}.",
  "PleaseEnterYourSearchPage": "Syötä hakusivusi URL",
  "Collapse": "Pienennä",
  "Collapsable": "Pienennettävä",
  "Expand": "Laajenna",
  "Today": "Tänään",
  "Yesterday": "Eilen",
  "Tomorrow": "Huomenna",
  "Duration": "Kesto: {0}",
  "IndexDuration": "Hakemiston kesto: {0}",
  "ProxyDuration": "Välityspalvelimen kesto: {0}",
  "ClientDuration": "Asiakkaan kesto: {0}",
  "Unavailable": "Ei saatavissa",
  "Reply": "Vastaa",
  "ReplyAll": "Vastaa kaikille",
  "Forward": "Välitä eteenpäin",
  "From": "Lähettäjä",
  "Caption": "Kuvateksti",
  "Expression": "Ilmaisu",
  "Tab": "Välilehti",
  "Tabs": "Välilehdet",
  "EnterExpressionName": "Syötä ilmaisun nimi",
  "EnterExpressionToFilterWith": "Syötä ilmaisu suodattaaksesi tulokset",
  "SelectTab": "Valitse välilehti",
  "SelectAll": "Valitse kaikki",
  "PageUrl": "Hakusivu URL",
  "ErrorSavingToDevice": "Virhe tietojen tallennuksessa laitteellesi",
  "ErrorReadingFromDevice": "Virhe tietoja luettaessa laitteeltasi",
  "AppIntro": "Puhu tuoteasiantuntijan kanssa, joka pystyy vastaamaan kysymyksiisi   Coveosta ja auttamaan sinua päättämään, mikä Coveo-ratkaisu on oikea sinulle. Kokeile live-demoa!",
  "TryDemo": "Kokeile demoa",
  "ContactUs": "Ota meihin yhteyttä",
  "NewToCoveo": "Uusi Coveossa?",
  "LetUsHelpGetStarted": "Anna meidän auttaa sinut alkuun",
  "LikesThis": "{0} <pl>pitävät</pl><sn>pitää</sn> tästä.",
  "CannotConnectSearchPage": "Hakusivullesi ei pystytä yhdistämään",
  "AreYouSureDeleteFilter": "Oletko varma, että haluat poistaa suodattimen {0} ilmaisulla {1}",
  "OnlineHelp": "Verkkotuki",
  "Done": "Valmis",
  "SaveFacetState": "Tallenna tämä fasettitila",
  "ClearFacetState": "Tyhjennä fasettitila",
  "DisplayingTheOnlyMessage": "Näyttää ainoan viestin tässä keskustelussa",
  "NoNetworkConnection": "Ei verkkoyhteyttä",
  "UnknownConnection": "Tuntematon yhteys",
  "EthernetConnection": "Ethernet-yhteys",
  "WiFi": "WiFi-yhteys",
  "CELL": "Mobiiliyhteys",
  "CELL_2G": "2G-mobiiliyhteys",
  "CELL_3G": "3G-mobiiliyhteys",
  "CELL_4G": "4G-mobiiliyhteys",
  "Relevance": "Merkitys",
  "Date": "Päivämäärä",
  "Amount": "Määrä",
  "QueryExceptionNoException": "Ei poikkeusta",
  "QueryExceptionInvalidSyntax": "Virheellinen syntaksi",
  "QueryExceptionInvalidCustomField": "Virheellinen räätälöity kenttä",
  "QueryExceptionInvalidDate": "Virheellinen päivämäärä",
  "QueryExceptionInvalidExactPhrase": "Virheellinen tarkka lauseke",
  "QueryExceptionInvalidDateOp": "Virheellinen päiväyskäyttäjä",
  "QueryExceptionInvalidNear": "Virheellinen NEAR-käyttäjä",
  "QueryExceptionInvalidWeightedNear": "Virheellinen painotettu NEAR",
  "QueryExceptionInvalidTerm": "Virheellinen termi",
  "QueryExceptionTooManyTerms": "Liian monta termiä",
  "QueryExceptionWildcardTooGeneral": "Liian yleinen villikortti",
  "QueryExceptionInvalidSortField": "Virheellinen lajittelukenttä",
  "QueryExceptionInvalidSmallStringOp": "Virheellinen pienen jonon käyttäjä",
  "QueryExceptionRequestedResultsMax": "Pyydettyjä tuloksia enintään",
  "QueryExceptionAggregatedMirrorDead": "Koottu peili on pois verkosta",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Kootun peilin kyselyn aikakatkaisu",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Kootun peilin virheellinen rakennusnumero",
  "QueryExceptionAggregatedMirrorCannotConnect": "Koottuun peiliin ei voida yhdistää",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Ei tarpeeksi johtavan merkin villikortteja",
  "QueryExceptionSecurityInverterNotFound": "Turvallisuusmuunninta ei löytynyt",
  "QueryExceptionSecurityInverterAccessDenied": "Turvallisuusmuuntimen käyttöoikeus kielletty",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Koottu peili ei pysty esiintymään toisena",
  "QueryExceptionUnexpected": "Odottamaton",
  "QueryExceptionAccessDenied": "Käyttöoikeus kielletty",
  "QueryExceptionSuperUserTokenInvalid": "Superkäyttäjän merkki virheellinen",
  "QueryExceptionSuperUserTokenExpired": "Superkäyttäjän merkki vanhentunut",
  "QueryExceptionLicenseQueriesExpired": "Kyselyjen lisenssi vanhentunut",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Lisenssiä superkäyttäjän merkille ei tueta",
  "QueryExceptionInvalidSession": "Virheellinen istunto",
  "QueryExceptionInvalidDocument": "Virheellinen asiakirja",
  "QueryExceptionSearchDisabled": "Haku poistettu käytöstä",
  "FileType": "Tiedostotyyppi",
  "ShowAttachment": "Näytä liite",
  "OnFeed": "{0}:n syötteestä.",
  "Author": "Tekijä",
  "NoTitle": "Ei otsikkoa",
  "CurrentSelections": "Nykyiset valinnat",
  "AllContent": "Koko sisältö",
  "CancelLastAction": "Peruuta viimeinen toiminta",
  "SearchTips": "Hakuvihjeet",
  "CheckSpelling": "Tarkasta asiasanojen kirjoitusasu.",
  "TryUsingFewerKeywords": "Kokeile käyttää vähemmän, erilaisia tai yleisempiä asiasanoja.",
  "SelectFewerFilters": "Valitse vähemmän suodattimia hakusi laajentamiseksi.",
  "Document": "Asiakirja",
  "Time": "Aika",
  "StartDate": "Aloituspäivä",
  "StartTime": "Aloitusaika",
  "DurationTitle": "Kesto",
  "UserQuery": "Käyttäjäkysely",
  "ShowUserActions": "Näytä käyttäjän toiminta",
  "NoData": "Tietoja ei saatavilla",
  "EventType": "Tapahtumatyyppi",
  "GoToFullSearch": "Täysi haku",
  "GoToEdition": "Räätälöi paneeli",
  "RemoveContext": "Poista konteksti",
  "BoxAttachToCase": "Liitä pyyntöön",
  "AttachToCase": "Liitä pyyntöön",
  "Attach": "Liitä",
  "Attached": "Liitetty",
  "Detach": "Irrota",
  "Details": "Tietoja",
  "AdditionalFilters": "Lisäsuodattimet",
  "SelectNonContextualSearch": "Poista konteksti tämänhetkisestä kirjauksesta laajentaaksesi hakua",
  "CopyPasteToSupport": "Kopioi ja liitä tämä viesti lisätiedoksi Coveon tukitiimille.",
  "FollowQueryDescription": "Ilmoita minulle tämän kyselyn hakutulosten muutoksista.",
  "SearchAlerts_Panel": "Hallitse hälytyksiä",
  "SearchAlerts_PanelDescription": "Tarkastele ja hallinnoi hakuhälytyksiä.",
  "SearchAlerts_PanelNoSearchAlerts": "Sinulla ei ole tilauksia.",
  "SearchAlerts_Fail": "Hakuhälytysten palvelu ei ole tällä hetkellä käytettävissä.",
  "SearchAlerts_Type": "Tyyppi",
  "SearchAlerts_Content": "Sisältö",
  "SearchAlerts_Actions": "Toiminta",
  "EmptyQuery": "<tyhjä>",
  "SearchAlerts_Type_followQuery": "Kysely",
  "SearchAlerts_Type_followDocument": "Kohta",
  "SearchAlerts_unFollowing": "Lopeta seuraaminen",
  "SearchAlerts_follow": "Seuraa",
  "SearchAlerts_followed": "Seurattu",
  "SearchAlerts_followQuery": "Seuraa kyselyä",
  "Subscription_StopFollowingQuery": "Lopeta kyselyn seuraaminen",
  "SearchAlerts_Frequency": "Kun",
  "SubscriptionsManageSubscriptions": "Hallitse hälytyksiä",
  "SubscriptionsMessageFollowQuery": "Saat hälytyksiä, kun kysely <b>{0}</b> uudistetaan tai sitä päivitetään.",
  "SubscriptionsMessageFollow": "Saat hälytyksiä muutoksista kohteelle <b>{0}</b>.",
  "Expiration": "Umpeutuminen",
  "Monthly": "Kuukausittain",
  "Daily": "Päivittäin",
  "Monday": "Maanantai",
  "Tuesday": "Tiistai",
  "Wednesday": "Keskiviikko",
  "Thursday": "Torstai",
  "Friday": "Perjantai",
  "Saturday": "Lauantai",
  "Sunday": "Sunnuntai",
  "NextDay": "Seuraava {0}",
  "LastDay": "Viime {0}",
  "StartTypingCaseForSuggestions": "Kuvaile ongelmaasi nähdäksesi mahdollisia ratkaisuja",
  "ExportToExcel": "Tuo Exceliin",
  "ExportToExcelDescription": "Tuo hakutulokset Exceliin",
  "CaseCreationNoResults": "Suositeltuja ratkaisuja ei löytynyt",
  "SortBy": "Lajittelutapa",
  "BoxCreateArticle": "Luo artikkeli",
  "Facets": "Fasetit",
  "AdvancedSearch": "Tarkennettu haku",
  "Keywords": "Avainsanat",
  "AllTheseWords": "Kaikki nämä sanat",
  "ExactPhrase": "Sanatarkasti tämä lause",
  "AnyOfTheseWords": "Mikä tahansa näistä sanoista",
  "NoneOfTheseWords": "Mikään näistä sanoista",
  "Anytime": "Milloin tahansa",
  "InTheLast": "Viimeisessä",
  "Days": "päivää",
  "Months": "kuukautta",
  "Month": "Kuukausi",
  "Year": "Vuosi",
  "Between": "Välillä",
  "Language": "Kieli",
  "Size": "Koko",
  "AtLeast": "vähintään",
  "AtMost": "enintään",
  "Contains": "sisältää",
  "DoesNotContain": "ei sisällä",
  "Matches": "vastaa",
  "Bytes": "tavua",
  "card": "Kortti",
  "table": "Taulukko",
  "ResultLinks": "Tuloslinkit",
  "EnableQuerySyntax": "Salli kyselyn syntaksi",
  "On": "Päällä",
  "Off": "Poispäältä",
  "Automatic": "Automaattinen",
  "ResultsPerPage": "Tuloksia per sivu",
  "PreviousMonth": "Edellinen kuukausi",
  "NextMonth": "Seuraava kuukausi",
  "Title": "Otsikko",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["fi"] = merge(locales["fi"], dict);
  String["toLocaleString"].call(this, { "fi": dict });
  String["locale"] = "fi";
  String["defaultLocale"] = "en";
  Globalize.culture("fi")
}